/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.rsf;

import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.RsfFru;
import com.ibm.hwmca.xfw.rsf.RsfMachineInfo;
import com.ibm.hwmca.xfw.rsf.RsfRefCode;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;
import java.util.Collection;
import java.util.Iterator;

public class ProblemReportRequestBody
extends XFrameRsfRequestBody {
    private static final String TRACE_MASKT = "XRSFXF T";
    private static final String TRACE_MASKF = "XRSFXF F";
    private static final String TRACE_MASKD = "XRSFXF D";
    public static final int HIGH_PERFORMANCE_CONNECTION = 1;
    private static int DEFAULT_ALTERNATE_FILE_LIST_CRITERIA = 1;
    private RsfMachineInfo failingMachInfo = null;
    private Collection fileList = null;
    private Collection alternateFileList = null;
    private int alternateFileListCriteria = DEFAULT_ALTERNATE_FILE_LIST_CRITERIA;
    private boolean useAlternateFileList = false;
    private Collection fruList = null;
    private Collection refCodeList = null;

    public ProblemReportRequestBody() {
        this.functionUserid = (char)49;
        this.functionId = (char)48;
    }

    public ProblemReportRequestBody(PersistentData data) {
        super(((Persistent)data).parentData);
        this.failingMachInfo = ((Persistent)data).failingMachInfo;
        this.fileList = ((Persistent)data).fileList;
        this.alternateFileList = ((Persistent)data).alternateFileList;
        this.alternateFileListCriteria = ((Persistent)data).alternateFileListCriteria;
        this.useAlternateFileList = ((Persistent)data).useAlternateFileList;
        this.fruList = ((Persistent)data).fruList;
        this.refCodeList = ((Persistent)data).refCodeList;
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        result.failingMachInfo = this.failingMachInfo;
        result.fileList = this.fileList;
        result.fruList = this.fruList;
        result.refCodeList = this.refCodeList;
        return result;
    }

    public boolean isValid() {
        return super.isValid();
    }

    public void setMachineInfo(RsfMachineInfo machineInfo) {
        this.failingMachInfo = machineInfo;
    }

    public RsfMachineInfo getMachineInfo() {
        return this.failingMachInfo;
    }

    public void setFileList(Collection files) {
        this.fileList = files;
    }

    public Collection getFileList() {
        return this.fileList;
    }

    public void setAlternateFileList(Collection files) {
        this.alternateFileList = files;
    }

    public Collection getAlternateFileList() {
        return this.alternateFileList;
    }

    public void setAlternateFileListCriteria(int altUseCriteria) {
        this.alternateFileListCriteria = altUseCriteria;
    }

    public int getAlternateFileListCriteria() {
        return this.alternateFileListCriteria;
    }

    public void setUseAlternateFileList(boolean useAltList) {
        this.useAlternateFileList = useAltList;
    }

    public boolean getUseAlternateFileList() {
        return this.useAlternateFileList;
    }

    public void setFruList(Collection frus) {
        this.fruList = frus;
    }

    public Collection getFruList() {
        return this.fruList;
    }

    public void setRefCodeList(Collection refCodes) {
        this.refCodeList = refCodes;
    }

    public Collection getRefCodeList() {
        return this.refCodeList;
    }

    private String buildRefCodeListXmlFormat(boolean toString) {
        StringBuffer buffer;
        block7: {
            if (this.refCodeList == null || this.refCodeList.isEmpty()) {
                return "";
            }
            buffer = new StringBuffer("<RCLIST>");
            if (toString) {
                buffer.append('\n');
            }
            try {
                Iterator refCodes = this.refCodeList.iterator();
                while (refCodes.hasNext()) {
                    if (toString) {
                        buffer.append("  ");
                    }
                    buffer.append(((RsfRefCode)refCodes.next()).toString());
                    if (!toString) continue;
                    buffer.append('\n');
                }
            }
            catch (ClassCastException e) {
                Trace.trace(TRACE_MASKF, "Object in ref code list is not a RsfRefCode");
                if (toString) break block7;
                throw e;
            }
        }
        buffer.append("</RCLIST>");
        if (toString) {
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private String buildFruListXmlFormat(boolean toString) {
        StringBuffer buffer;
        block7: {
            if (this.fruList == null || this.fruList.isEmpty()) {
                return "";
            }
            buffer = new StringBuffer("<FRULIST>");
            if (toString) {
                buffer.append('\n');
            }
            try {
                Iterator frus = this.fruList.iterator();
                while (frus.hasNext()) {
                    if (toString) {
                        buffer.append("  ");
                    }
                    buffer.append(((RsfFru)frus.next()).toString());
                    if (!toString) continue;
                    buffer.append('\n');
                }
            }
            catch (ClassCastException e) {
                Trace.trace(TRACE_MASKF, "Object in fru list is not a RsfFru");
                if (toString) break block7;
                throw e;
            }
        }
        buffer.append("</FRULIST>");
        if (toString) {
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public String toXmlTransferFormat() {
        StringBuffer buffer = new StringBuffer(this.buildUseridAndFunction());
        buffer.append(super.toXmlTransferFormat());
        if (this.failingMachInfo != null) {
            buffer.append(this.failingMachInfo.toXmlTransferFormat());
        }
        Collection usingFileList = this.useAlternateFileList ? this.alternateFileList : this.fileList;
        buffer.append(this.buildFileListXmlFormat(usingFileList, false));
        buffer.append(this.buildFruListXmlFormat(false));
        buffer.append(this.buildRefCodeListXmlFormat(false));
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.buildUseridAndFunction());
        buffer.append(super.toString());
        if (this.failingMachInfo != null) {
            buffer.append(this.failingMachInfo.toString());
        }
        Collection usingFileList = this.useAlternateFileList ? this.alternateFileList : this.fileList;
        buffer.append(this.buildFileListXmlFormat(usingFileList, true));
        buffer.append(this.buildFruListXmlFormat(true));
        buffer.append(this.buildRefCodeListXmlFormat(true));
        return buffer.toString();
    }

    private static class Persistent
    implements PersistentData {
        PersistentData parentData;
        RsfMachineInfo failingMachInfo;
        Collection fileList;
        Collection alternateFileList;
        int alternateFileListCriteria;
        boolean useAlternateFileList;
        Collection fruList;
        Collection refCodeList;
        int version = 0;
        private static final long serialVersionUID = 1L;

        private Persistent() {
        }
    }
}

